from dotenv import load_dotenv
import os

load_dotenv(override=True)

ENV = os.getenv('ENV')

DB_HOST = os.getenv('DB_HOST')
DB_USER = os.getenv('DB_USER')
DB_PASSWORD = os.getenv('DB_PASSWORD')

if ENV == 'UAT':
    DB_NAME = os.getenv('UAT_DB_NAME')
    PORT=os.getenv('UAT_PORT')
elif ENV == 'PROD':
    DB_NAME = os.getenv('PROD_DB_NAME')
    PORT=os.getenv('PROD_PORT')
else:
    print("Invalid Environment Variable")

GOOGLE_API_KEY = os.getenv('GOOGLE_API_KEY')

print("Port", PORT)